//*****************************************************************************
//
//	File:		 TDotsWindow.h
//
//	Description: WindowScreen class playing dominos, headers.
//
//	Copyright 1996, Be Incorporated
//
//*****************************************************************************

#ifndef __TDotsWindow
#define __TDotsWindow

#ifndef _WINDOW_SCREEN_H
#include <WindowScreen.h>
#endif
#ifndef _OS_H
#include <OS.h>
#endif

class TDotsWindow : public BWindowScreen {
public:
	                TDotsWindow(uint32 space, char *name, status_t *error);
virtual void        Quit();
virtual	void		ScreenConnected(bool active);
thread_id           draw;
};

void 	plot_point(long x, long y,uchar inColor);
void 	plot_dot(long x, long y,uchar inColor);
void 	draw();
void 	clear_buffer(uchar inColor);
void 	CopyBuffer();
void 	SwitchBuffer();

// Global Variables

extern 	int       drawing_enabled;
extern 	int       kill_play;
extern	int       page_num;
extern	sem_id    lock;
extern	sem_id    ender;
extern	TDotsWindow *window;

extern  long     row;
extern  BRect	 gBounds;

extern  uchar    *draw_base;


// Inline function need to be here 
inline void plot_point(long x, long y,uchar inColor)
{
	if ( gBounds.left <= x && gBounds.right > x+1 && gBounds.top <= y && gBounds.bottom > y+1 )
	{
		*(draw_base + (y * row)+ x ) = inColor;
	}
}

inline void plot_dot(long x, long y,uchar inColor)
{
	uchar *theAdd;
	if ( gBounds.left <= x && gBounds.right > x+2 && gBounds.top <= y && gBounds.bottom > y+2 )
	{
		theAdd = (draw_base + (y * row)+ x );
		*theAdd = inColor;
		*(theAdd+row) = inColor;
		*(theAdd+1) = inColor;
		*(theAdd+row+1) = inColor;
		
	}
}

#endif
